/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.jnlp;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.TemplatePlaceholders;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.cert.CertificateEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JNLPBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(JNLPBundler.class.getName());
    private static final String dtFX = "dtjava.js";
    private static final String webfilesDir = "web-files";
    private static final String EMBEDDED_DT = "./web-files/dtjava.js";
    private static final String PUBLIC_DT = "http://java.com/js/dtjava.js";
    public static final StandardBundlerParam<String> OUT_FILE = new StandardBundlerParam<String>(I18N.getString("param.out-file.name"), I18N.getString("param.out-file.description"), "jnlp.outfile", String.class, null, null);
    public static final StandardBundlerParam<Boolean> SWING_APP = new StandardBundlerParam<Boolean>(I18N.getString("param.swing-app.name"), I18N.getString("param.swing-app.description"), "jnlp.swingApp", Boolean.class, p -> Boolean.FALSE, (s, p) -> Boolean.parseBoolean(s));
    public static final StandardBundlerParam<Boolean> INCLUDE_DT = new StandardBundlerParam<Boolean>(I18N.getString("param.include-deployment-toolkit.name"), I18N.getString("param.include-deployment-toolkit.description"), "jnlp.includeDT", Boolean.class, p -> Boolean.FALSE, (s, p) -> Boolean.parseBoolean(s));
    public static final StandardBundlerParam<Boolean> EMBED_JNLP = new StandardBundlerParam<Boolean>(I18N.getString("param.embed-jnlp.name"), I18N.getString("param.embed-jnlp.description"), "jnlp.embedJnlp", Boolean.class, p -> Boolean.FALSE, (s, p) -> Boolean.parseBoolean(s));
    public static final StandardBundlerParam<Boolean> EXTENSION = new StandardBundlerParam<Boolean>(I18N.getString("param.extension.name"), I18N.getString("param.extension.description"), "jnlp.extension", Boolean.class, p -> Boolean.FALSE, (s, p) -> Boolean.parseBoolean(s));
    public static final StandardBundlerParam<Map<File, File>> TEMPLATES = new StandardBundlerParam<Map>(I18N.getString("param.templates.name"), I18N.getString("param.templates.description"), "jnlp.templates", Map.class, p -> new LinkedHashMap(), null);
    public static final StandardBundlerParam<String> CODEBASE = new StandardBundlerParam<String>(I18N.getString("param.codebase.name"), I18N.getString("param.codebase.description"), "jnlp.codebase", String.class, p -> null, null);
    public static final StandardBundlerParam<String> PLACEHOLDER = new StandardBundlerParam<String>(I18N.getString("param.placeholder.name"), I18N.getString("param.placeholder.description"), "jnlp.placeholder", String.class, p -> "'javafx-app-placeholder'", (s, p) -> {
        if (!s.startsWith("'")) {
            s = "'" + s;
        }
        if (!s.endsWith("'")) {
            s = s + "'";
        }
        return s;
    });
    public static final StandardBundlerParam<Boolean> OFFLINE_ALLOWED = new StandardBundlerParam<Boolean>(I18N.getString("param.offline-allowed.name"), I18N.getString("param.offline-allowed.description"), "jnlp.offlineAllowed", Boolean.class, p -> true, (s, p) -> Boolean.valueOf(s));
    public static final StandardBundlerParam<Boolean> ALL_PERMISSIONS = new StandardBundlerParam<Boolean>(I18N.getString("param.all-permissions.name"), I18N.getString("param.all-permissions.description"), "jnlp.allPermisions", Boolean.class, p -> false, (s, p) -> Boolean.valueOf(s));
    public static final StandardBundlerParam<Integer> WIDTH = new StandardBundlerParam<Integer>(I18N.getString("param.width.name"), I18N.getString("param.width.description"), "jnlp.width", Integer.class, p -> 0, (s, p) -> Integer.parseInt(s));
    public static final StandardBundlerParam<Integer> HEIGHT = new StandardBundlerParam<Integer>(I18N.getString("param.height.name"), I18N.getString("param.height.description"), "jnlp.height", Integer.class, p -> 0, (s, p) -> Integer.parseInt(s));
    public static final StandardBundlerParam<String> EMBEDDED_WIDTH = new StandardBundlerParam<String>(I18N.getString("param.embedded-width.name"), I18N.getString("param.embedded-width.description"), "jnlp.embeddedWidth", String.class, p -> Integer.toString((Integer)WIDTH.fetchFrom((Map<String, Object>)p)), (s, p) -> s);
    public static final StandardBundlerParam<String> EMBEDDED_HEIGHT = new StandardBundlerParam<String>(I18N.getString("param.embedded-height.name"), I18N.getString("param.embedded-height.description"), "jnlp.embeddedHeight", String.class, p -> Integer.toString((Integer)HEIGHT.fetchFrom((Map<String, Object>)p)), (s, p) -> s);
    public static final StandardBundlerParam<String> FALLBACK_APP = new StandardBundlerParam<String>(I18N.getString("param.fallback-app.name"), I18N.getString("param.fallback-app.description"), "jnlp.fallbackApp", String.class, p -> null, (s, p) -> s);
    public static final StandardBundlerParam<String> UPDATE_MODE = new StandardBundlerParam<String>(I18N.getString("param.update-mode.name"), I18N.getString("param.update-mode.description"), "jnlp.updateMode", String.class, p -> null, (s, p) -> s);
    public static final StandardBundlerParam<String> FX_PLATFORM = new StandardBundlerParam<String>(I18N.getString("param.fx-platform.name"), I18N.getString("param.fx-platform.description"), "jnlp.fxPlatform", String.class, p -> "8.0", (s, p) -> s);
    public static final StandardBundlerParam<String> JRE_PLATFORM = new StandardBundlerParam<String>(I18N.getString("param.jre-platform.name"), I18N.getString("param.jre-platform.description"), "jnlp.jrePlatform", String.class, p -> "8.0", (s, p) -> s);
    public static final StandardBundlerParam<List<Map<String, ? super Object>>> ICONS = new StandardBundlerParam<List>(I18N.getString("param.icons.name"), I18N.getString("param.icons.description"), "jnlp.icons", List.class, params -> new ArrayList(1), null);
    public static final StandardBundlerParam<Map<String, String>> APP_PARAMS = new StandardBundlerParam<Map>(I18N.getString("param.params.name"), I18N.getString("param.params.description"), "jnlp.params", Map.class, params -> new HashMap(), null);
    public static final StandardBundlerParam<Map<String, String>> ESCAPED_APPLET_PARAMS = new StandardBundlerParam<Map>(I18N.getString("param.escaped-applet-params.name"), I18N.getString("param.escaped-applet-params.description"), "jnlp.escapedAppletParams", Map.class, params -> new HashMap(), null);
    public static final StandardBundlerParam<Map<String, String>> APPLET_PARAMS = new StandardBundlerParam<Map>(I18N.getString("param.applet-params.name"), I18N.getString("param.applet-params.description"), "jnlp.appletParams", Map.class, params -> new HashMap(), null);
    public static final StandardBundlerParam<Map<String, String>> JS_CALLBACKS = new StandardBundlerParam<Map>(I18N.getString("param.js-callbacks.name"), I18N.getString("param.js-callbacks.description"), "jnlp.jsCallbacks", Map.class, params -> new HashMap(), null);
    public static final StandardBundlerParam<String> ICONS_HREF = new StandardBundlerParam<String>(I18N.getString("param.icons-href.name"), I18N.getString("param.icons-href.description"), "jnlp.icons.href", String.class, null, null);
    public static final StandardBundlerParam<String> ICONS_KIND = new StandardBundlerParam<String>(I18N.getString("param.icons-kind.name"), I18N.getString("param.icons-kind.description"), "jnlp.icons.kind", String.class, params -> null, null);
    public static final StandardBundlerParam<String> ICONS_WIDTH = new StandardBundlerParam<String>(I18N.getString("param.icons-width.name"), I18N.getString("param.icons-width.description"), "jnlp.icons.width", String.class, params -> null, null);
    public static final StandardBundlerParam<String> ICONS_HEIGHT = new StandardBundlerParam<String>(I18N.getString("param.icons-height.name"), I18N.getString("param.icons-height.description"), "jnlp.icons.height", String.class, params -> null, null);
    public static final StandardBundlerParam<String> ICONS_DEPTH = new StandardBundlerParam<String>(I18N.getString("param.icons-depth.name"), I18N.getString("param.icons-depth.description"), "jnlp.icons.depth", String.class, params -> null, null);
    private static String[] webFiles = new String[]{"javafx-loading-100x100.gif", "dtjava.js", "javafx-loading-25x25.gif", "error.png", "upgrade_java.png", "javafx-chrome.png", "get_java.png", "upgrade_javafx.png", "get_javafx.png"};
    private static String prefixWebFiles = "/resources/web-files/";

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "jnlp";
    }

    @Override
    public String getBundleType() {
        return "JNLP";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return null;
    }

    @Override
    public boolean validate(Map<String, ? super Object> params) throws UnsupportedPlatformException, ConfigException {
        if (OUT_FILE.fetchFrom(params) == null) {
            throw new ConfigException(I18N.getString("error.no-outfile"), I18N.getString("error.no-outfile.advice"));
        }
        if (StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params) == null) {
            throw new ConfigException(I18N.getString("error.no-app-resources"), I18N.getString("error.no-app-resources.advice"));
        }
        if (!((Boolean)EXTENSION.fetchFrom(params)).booleanValue()) {
            StandardBundlerParam.validateMainClassInfoFromAppResources(params);
        }
        return true;
    }

    private String readTextFile(File in) throws PackagerException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(new FileInputStream(in));){
            int len;
            char[] buf = new char[16384];
            while ((len = isr.read(buf)) > 0) {
                sb.append(buf, sb.length(), len);
            }
        }
        catch (IOException ex) {
            throw new PackagerException(ex, "ERR_FileReadFailed", in.getAbsolutePath());
        }
        return sb.toString();
    }

    private String processTemplate(Map<String, ? super Object> params, String inpText, Map<TemplatePlaceholders, String> templateStrings) {
        String corePattern = "(#[\\w\\.\\(\\)]+#)";
        String prefixGeneric = "[\\/\\*-<\\!]*[ \\t]*";
        String suffixGeneric = "[ \\t]*[\\*\\/>-]*";
        Pattern mainPattern = Pattern.compile(prefixGeneric + corePattern + suffixGeneric);
        Matcher m = mainPattern.matcher(inpText);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String idPart;
            String match = m.group();
            String coreMatch = m.group(1);
            boolean inComment = match.startsWith("<!--") && match.endsWith("-->") || match.startsWith("//") || match.startsWith("/*") && match.endsWith(" */");
            String coreReplacement = null;
            String[] parts = coreMatch.substring(1, coreMatch.length() - 1).split("[\\(\\)]");
            String rulePart = parts[0];
            String string = idPart = parts.length == 1 ? null : parts[1];
            if (templateStrings.containsKey((Object)TemplatePlaceholders.fromString(rulePart)) && (idPart == null || idPart.equals(StandardBundlerParam.IDENTIFIER.fetchFrom(params)))) {
                coreReplacement = templateStrings.get((Object)TemplatePlaceholders.fromString(rulePart));
            }
            if (coreReplacement == null) continue;
            if (inComment || coreMatch.length() == match.length()) {
                m.appendReplacement(result, coreReplacement);
                continue;
            }
            int pp = match.indexOf(coreMatch);
            String v = match.substring(0, pp) + coreReplacement + match.substring(pp + coreMatch.length());
            m.appendReplacement(result, v);
        }
        m.appendTail(result);
        return result.toString();
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        Map templates = (Map)TEMPLATES.fetchFrom(params);
        boolean templateOn = !templates.isEmpty();
        EnumMap<TemplatePlaceholders, String> templateStrings = null;
        if (templateOn) {
            templateStrings = new EnumMap<TemplatePlaceholders, String>(TemplatePlaceholders.class);
        }
        try {
            PrintStream jnlp_ps;
            String outfile = (String)OUT_FILE.fetchFrom(params);
            boolean isSwingApp = (Boolean)SWING_APP.fetchFrom(params);
            String jnlp_filename_webstart = outfile + ".jnlp";
            String jnlp_filename_browser = isSwingApp ? outfile + "_browser.jnlp" : jnlp_filename_webstart;
            String html_filename = outfile + ".html";
            outputParentDir.mkdirs();
            boolean includeDT = (Boolean)INCLUDE_DT.fetchFrom(params);
            if (includeDT && !this.extractWebFiles(outputParentDir)) {
                throw new PackagerException("ERR_NoEmbeddedDT");
            }
            ByteArrayOutputStream jnlp_bos_webstart = new ByteArrayOutputStream();
            ByteArrayOutputStream jnlp_bos_browser = new ByteArrayOutputStream();
            if (isSwingApp) {
                jnlp_ps = new PrintStream(jnlp_bos_webstart);
                this.generateJNLP(params, jnlp_ps, jnlp_filename_webstart, Mode.SwingAPP);
                jnlp_ps.close();
                this.save(outputParentDir, jnlp_filename_webstart, jnlp_bos_webstart.toByteArray());
                jnlp_ps = new PrintStream(jnlp_bos_browser);
                this.generateJNLP(params, jnlp_ps, jnlp_filename_browser, Mode.APPLET);
                jnlp_ps.close();
                this.save(outputParentDir, jnlp_filename_browser, jnlp_bos_browser.toByteArray());
            } else {
                jnlp_ps = new PrintStream(jnlp_bos_browser);
                this.generateJNLP(params, jnlp_ps, jnlp_filename_browser, Mode.FX);
                jnlp_ps.close();
                this.save(outputParentDir, jnlp_filename_browser, jnlp_bos_browser.toByteArray());
                jnlp_bos_webstart = jnlp_bos_browser;
            }
            boolean isExtension = (Boolean)EXTENSION.fetchFrom(params);
            if (!isExtension) {
                ByteArrayOutputStream html_bos = new ByteArrayOutputStream();
                PrintStream html_ps = new PrintStream(html_bos);
                this.generateHTML(params, html_ps, jnlp_bos_browser.toByteArray(), jnlp_filename_browser, jnlp_bos_webstart.toByteArray(), jnlp_filename_webstart, templateStrings, isSwingApp);
                html_ps.close();
                if (templateOn) {
                    for (Map.Entry t : ((Map)TEMPLATES.fetchFrom(params)).entrySet()) {
                        File out = (File)t.getValue();
                        if (out == null) {
                            System.out.println("Perform inplace substitution for " + ((File)t.getKey()).getAbsolutePath());
                            out = (File)t.getKey();
                        }
                        this.save(out, this.processTemplate(params, this.readTextFile((File)t.getKey()), templateStrings).getBytes());
                    }
                } else {
                    this.save(outputParentDir, html_filename, html_bos.toByteArray());
                }
            }
            for (RelativeFileSet rfs : (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params)) {
                JNLPBundler.copyFiles(rfs, outputParentDir);
            }
            return outputParentDir;
        }
        catch (Exception ex) {
            Log.info("JNLP failed : " + ex.getMessage());
            ex.printStackTrace();
            Log.debug(ex);
            return null;
        }
    }

    private static void copyFiles(RelativeFileSet resources, File outdir) throws IOException, PackagerException {
        File rootDir = resources.getBaseDirectory();
        for (String s : resources.getIncludedFiles()) {
            File srcFile = new File(rootDir, s);
            if (!srcFile.exists() || !srcFile.isFile()) continue;
            File destFile = new File(outdir, s);
            if (!srcFile.getCanonicalFile().equals(destFile.getCanonicalFile())) {
                JNLPBundler.copyFileToOutDir(new FileInputStream(srcFile), destFile);
                continue;
            }
            Log.verbose(MessageFormat.format(I18N.getString("error.jar-no-self-copy"), s));
        }
    }

    private String getJvmArguments(Map<String, ? super Object> params, boolean includeProperties) {
        List jvmargs = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(params);
        Map properties = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(params);
        StringBuilder sb = new StringBuilder();
        for (String string : jvmargs) {
            sb.append(string);
            sb.append(" ");
        }
        if (includeProperties) {
            for (Map.Entry entry : properties.entrySet()) {
                sb.append("-D");
                sb.append((String)entry.getKey());
                sb.append("=");
                sb.append((String)entry.getValue());
                sb.append(" ");
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void generateJNLP(Map<String, ? super Object> params, PrintStream out, String jnlp_filename, Mode m) throws IOException, CertificateEncodingException {
        boolean allPermissions;
        boolean needShortcut;
        String codebase = (String)CODEBASE.fetchFrom(params);
        String title = (String)StandardBundlerParam.TITLE.fetchFrom(params);
        String vendor = (String)StandardBundlerParam.VENDOR.fetchFrom(params);
        String description = (String)StandardBundlerParam.DESCRIPTION.fetchFrom(params);
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<jnlp spec=\"1.0\" xmlns:jfx=\"http://javafx.com\"" + (codebase != null ? " codebase=\"" + codebase + "\"" : "") + " href=\"" + jnlp_filename + "\">");
        out.println("  <information>");
        out.println("    <title>" + (title != null ? title : "Sample JavaFX Application") + "</title>");
        out.println("    <vendor>" + (vendor != null ? vendor : "Unknown vendor") + "</vendor>");
        out.println("    <description>" + (description != null ? description : "Sample JavaFX 2.0 application.") + "</description>");
        for (Map iconInfo : (List)ICONS.fetchFrom(params)) {
            String href = (String)ICONS_HREF.fetchFrom(iconInfo);
            String kind = (String)ICONS_KIND.fetchFrom(iconInfo);
            String width = (String)ICONS_WIDTH.fetchFrom(iconInfo);
            String height = (String)ICONS_HEIGHT.fetchFrom(iconInfo);
            String string = (String)ICONS_DEPTH.fetchFrom(iconInfo);
            out.println("    <icon href=\"" + href + "\" " + (kind != null ? " kind=\"" + kind + "\"" : "") + (width != null ? " width=\"" + width + "\"" : "") + (height != null ? " height=\"" + (String)height + "\"" : "") + (string != null ? " depth=\"" + string + "\"" : "") + "/>");
        }
        boolean offlineAllowed = (Boolean)OFFLINE_ALLOWED.fetchFrom(params);
        boolean isExtension = (Boolean)EXTENSION.fetchFrom(params);
        if (offlineAllowed && !isExtension) {
            out.println("    <offline-allowed/>");
        }
        if (Boolean.TRUE.equals(needShortcut = ((Boolean)StandardBundlerParam.SHORTCUT_HINT.fetchFrom(params)).booleanValue())) {
            out.println("  <shortcut><desktop/></shortcut>");
        }
        out.println("  </information>");
        boolean needToCloseResourceTag = false;
        if (!isExtension) {
            out.println("  <resources>");
            needToCloseResourceTag = true;
            String vmargs = this.getJvmArguments(params, false);
            vmargs = vmargs == null ? "" : " java-vm-args=\"" + vmargs + "\" ";
            out.println("    <j2se version=\"" + (String)JRE_PLATFORM.fetchFrom(params) + "\"" + vmargs + " href=\"http://java.sun.com/products/autodl/j2se\"/>");
            for (Map.Entry entry : ((Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(params)).entrySet()) {
                out.println("    <property name=\"" + (String)entry.getKey() + "\" value=\"" + (String)entry.getValue() + "\"/>");
            }
        }
        String currentOS = null;
        String currentArch = null;
        Object var15_22 = null;
        for (RelativeFileSet rfs : (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params)) {
            if (!needToCloseResourceTag || currentOS == null && rfs.getOs() != null || currentOS != null && !currentOS.equals(rfs.getOs()) || currentArch == null && rfs.getArch() != null || currentArch != null && !currentArch.equals(rfs.getArch())) {
                void var15_26;
                if (needToCloseResourceTag) {
                    String string = "  </resources>\n";
                } else {
                    String string = "";
                }
                currentOS = rfs.getOs();
                currentArch = rfs.getArch();
                String string = (String)var15_26 + "  <resources" + (currentOS != null ? " os=\"" + currentOS + "\"" : "") + (currentArch != null ? " arch=\"" + currentArch + "\"" : "") + ">\n";
            }
            for (String relativePath : rfs.getIncludedFiles()) {
                File srcFile = new File(rfs.getBaseDirectory(), relativePath);
                if (!srcFile.exists() || !srcFile.isFile()) continue;
                RelativeFileSet.Type type = rfs.getType();
                if (type == RelativeFileSet.Type.UNKNOWN) {
                    if (relativePath.endsWith(".jar")) {
                        type = RelativeFileSet.Type.jar;
                    } else if (relativePath.endsWith(".jnlp")) {
                        type = RelativeFileSet.Type.jnlp;
                    } else if (relativePath.endsWith(".dll")) {
                        type = RelativeFileSet.Type.nativelib;
                    } else if (relativePath.endsWith(".so")) {
                        type = RelativeFileSet.Type.nativelib;
                    } else if (relativePath.endsWith(".dylib")) {
                        type = RelativeFileSet.Type.nativelib;
                    }
                }
                switch (type) {
                    case jar: {
                        void var15_23;
                        if (var15_23 != null) {
                            out.print((String)var15_23);
                            Object var15_28 = null;
                            needToCloseResourceTag = true;
                        }
                        out.print("    <jar href=\"" + relativePath + "\" size=\"" + srcFile.length() + "\"");
                        out.print(" download=\"" + rfs.getMode() + "\" ");
                        out.println("/>");
                        break;
                    }
                    case jnlp: {
                        void var15_23;
                        if (var15_23 != null) {
                            out.print((String)var15_23);
                            Object var15_29 = null;
                            needToCloseResourceTag = true;
                        }
                        out.println("    <extension href=\"" + relativePath + "\"/>");
                        break;
                    }
                    case nativelib: {
                        void var15_23;
                        if (var15_23 != null) {
                            out.print((String)var15_23);
                            needToCloseResourceTag = true;
                            Object var15_30 = null;
                        }
                        out.println("    <nativelib href=\"" + relativePath + "\"/>");
                    }
                }
            }
        }
        if (needToCloseResourceTag) {
            out.println("  </resources>");
        }
        if (allPermissions = ((Boolean)ALL_PERMISSIONS.fetchFrom(params)).booleanValue()) {
            out.println("<security>");
            out.println("  <all-permissions/>");
            out.println("</security>");
        }
        if (!isExtension) {
            Integer width = (Integer)WIDTH.fetchFrom(params);
            Integer height = (Integer)HEIGHT.fetchFrom(params);
            if (width == null) {
                width = 0;
            }
            if (height == null) {
                height = 0;
            }
            String applicationClass = (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(params);
            String preloader = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(params);
            Map appParams = (Map)APP_PARAMS.fetchFrom(params);
            List arguments = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(params);
            String appName = (String)StandardBundlerParam.APP_NAME.fetchFrom(params);
            if (m == Mode.APPLET) {
                out.print("  <applet-desc  width=\"" + width + "\" height=\"" + height + "\"");
                out.print(" main-class=\"" + applicationClass + "\" ");
                out.println(" name=\"" + appName + "\" >");
                for (Map.Entry appParamEntry : appParams.entrySet()) {
                    out.println("    <param name=\"" + (String)appParamEntry.getKey() + "\"" + (appParamEntry.getValue() != null ? " value=\"" + (String)appParamEntry.getValue() + "\"" : "") + "/>");
                }
                out.println("  </applet-desc>");
            } else if (m == Mode.SwingAPP) {
                out.print("  <application-desc main-class=\"" + applicationClass + "\" ");
                out.println(" name=\"" + appName + "\" >");
                for (String a : arguments) {
                    out.println("    <argument>" + a + "</argument>");
                }
                out.println("  </application-desc>");
            } else {
                String fallbackApp = (String)FALLBACK_APP.fetchFrom(params);
                if (fallbackApp != null) {
                    out.print("  <applet-desc  width=\"" + width + "\" height=\"" + height + "\"");
                    out.print(" main-class=\"" + fallbackApp + "\" ");
                    out.println(" name=\"" + appName + "\" >");
                    out.println("    <param name=\"requiredFXVersion\" value=\"" + (String)FX_PLATFORM.fetchFrom(params) + "\"/>");
                    out.println("  </applet-desc>");
                }
                out.print("  <jfx:javafx-desc  width=\"" + width + "\" height=\"" + height + "\"");
                out.print(" main-class=\"" + applicationClass + "\" ");
                out.print(" name=\"" + appName + "\" ");
                if (preloader != null) {
                    out.print(" preloader-class=\"" + preloader + "\"");
                }
                if ((appParams == null || appParams.isEmpty()) && (arguments == null || arguments.isEmpty())) {
                    out.println("/>");
                } else {
                    out.println(">");
                    if (appParams != null) {
                        for (Map.Entry appParamEntry : appParams.entrySet()) {
                            out.println("    <fx:param name=\"" + (String)appParamEntry.getKey() + "\"" + (appParamEntry.getValue() != null ? " value=\"" + (String)appParamEntry.getValue() + "\"" : "") + "/>");
                        }
                    }
                    if (arguments != null) {
                        for (String a : arguments) {
                            out.println("    <fx:argument>" + a + "</fx:argument>");
                        }
                    }
                    out.println("  </jfx:javafx-desc>");
                }
            }
        }
        out.println("  <update check=\"" + (String)UPDATE_MODE.fetchFrom(params) + "\"/>");
        out.println("</jnlp>");
    }

    private void addToList(List<String> l, String name, String value, boolean isString) {
        String s = isString ? "'" : "";
        String v = name + " : " + s + value + s;
        l.add(v);
    }

    private String listToString(List<String> lst, String offset) {
        StringBuilder b = new StringBuilder();
        if (lst == null || lst.isEmpty()) {
            return offset + "{}";
        }
        b.append(offset).append("{\n");
        boolean first = true;
        for (String s : lst) {
            if (!first) {
                b.append(",\n");
            }
            first = false;
            b.append(offset).append("    ");
            b.append(s);
        }
        b.append("\n");
        b.append(offset).append("}");
        return b.toString();
    }

    private String encodeAsBase64(byte[] inp) {
        return Base64.getEncoder().encodeToString(inp);
    }

    private void generateHTML(Map<String, ? super Object> params, PrintStream out, byte[] jnlp_bytes_browser, String jnlpfile_browser, byte[] jnlp_bytes_webstart, String jnlpfile_webstart, Map<TemplatePlaceholders, String> templateStrings, boolean swingMode) {
        boolean isSwingApp;
        String poff = "    ";
        String poff2 = poff + poff;
        String poff3 = poff2 + poff;
        StringBuilder out_embed_dynamic = new StringBuilder();
        StringBuilder out_embed_onload = new StringBuilder();
        StringBuilder out_launch_code = new StringBuilder();
        String appletParams = this.getAppletParameters(params);
        String jnlp_content_browser = null;
        String jnlp_content_webstart = null;
        boolean embedJNLP = (Boolean)EMBED_JNLP.fetchFrom(params);
        boolean includeDT = (Boolean)INCLUDE_DT.fetchFrom(params);
        if (embedJNLP) {
            jnlp_content_browser = this.encodeAsBase64(jnlp_bytes_browser);
            jnlp_content_webstart = this.encodeAsBase64(jnlp_bytes_webstart);
        }
        out.println("<html><head>");
        String dtURL = includeDT ? EMBEDDED_DT : PUBLIC_DT;
        String includeDtString = "<SCRIPT src=\"" + dtURL + "\"></SCRIPT>";
        if (templateStrings != null) {
            templateStrings.put(TemplatePlaceholders.SCRIPT_URL, dtURL);
            templateStrings.put(TemplatePlaceholders.SCRIPT_CODE, includeDtString);
        }
        out.println("  " + includeDtString);
        ArrayList<String> w_app = new ArrayList<String>();
        ArrayList<String> w_platform = new ArrayList<String>();
        ArrayList<String> w_callback = new ArrayList<String>();
        this.addToList(w_app, "url", jnlpfile_webstart, true);
        if (jnlp_content_webstart != null) {
            this.addToList(w_app, "jnlp_content", jnlp_content_webstart, true);
        }
        this.addToList(w_platform, "javafx", (String)FX_PLATFORM.fetchFrom(params), true);
        String vmargs = this.getJvmArguments(params, true);
        if (vmargs != null) {
            this.addToList(w_platform, "jvmargs", vmargs, true);
        }
        if (!"".equals(appletParams)) {
            this.addToList(w_app, "params", "{" + appletParams + "}", false);
        }
        for (Map.Entry callbackEntry : ((Map)JS_CALLBACKS.fetchFrom(params)).entrySet()) {
            this.addToList(w_callback, (String)callbackEntry.getKey(), (String)callbackEntry.getValue(), false);
        }
        out_launch_code.append(poff2).append("dtjava.launch(");
        out_launch_code.append(this.listToString(w_app, poff3)).append(",\n");
        out_launch_code.append(this.listToString(w_platform, poff3)).append(",\n");
        out_launch_code.append(this.listToString(w_callback, poff3)).append("\n");
        out_launch_code.append(poff2).append(");\n");
        out.println("<script>");
        out.println(poff + "function launchApplication(jnlpfile) {");
        out.print(out_launch_code.toString());
        out.println(poff2 + "return false;");
        out.println(poff + "}");
        out.println("</script>");
        if (templateStrings != null) {
            templateStrings.put(TemplatePlaceholders.LAUNCH_CODE, out_launch_code.toString());
        }
        String appId = (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params);
        String placeholder = (String)PLACEHOLDER.fetchFrom(params);
        ArrayList<String> p_app = new ArrayList<String>();
        ArrayList<String> p_platform = new ArrayList<String>();
        ArrayList<String> p_callback = new ArrayList<String>();
        if (appId != null) {
            this.addToList(p_app, "id", appId, true);
        }
        if (isSwingApp = ((Boolean)SWING_APP.fetchFrom(params)).booleanValue()) {
            this.addToList(p_app, "toolkit", "swing", true);
        }
        this.addToList(p_app, "url", jnlpfile_browser, true);
        this.addToList(p_app, "placeholder", placeholder, false);
        this.addToList(p_app, "width", (String)EMBEDDED_WIDTH.fetchFrom(params), true);
        this.addToList(p_app, "height", (String)EMBEDDED_HEIGHT.fetchFrom(params), true);
        if (jnlp_content_browser != null) {
            this.addToList(p_app, "jnlp_content", jnlp_content_browser, true);
        }
        this.addToList(p_platform, "javafx", (String)FX_PLATFORM.fetchFrom(params), true);
        if (vmargs != null) {
            this.addToList(p_platform, "jvmargs", vmargs, true);
        }
        for (Map.Entry entry : ((Map)JS_CALLBACKS.fetchFrom(params)).entrySet()) {
            this.addToList(p_callback, (String)entry.getKey(), (String)entry.getValue(), false);
        }
        if (!"".equals(appletParams)) {
            this.addToList(p_app, "params", "{" + appletParams + "}", false);
        }
        if (swingMode) {
            boolean needOnGetSplashImpl = true;
            for (String callback : ((Map)JS_CALLBACKS.fetchFrom(params)).keySet()) {
                if (!"onGetSplash".equals(callback)) continue;
                needOnGetSplashImpl = false;
            }
            if (needOnGetSplashImpl) {
                this.addToList(p_callback, "onGetSplash", "function() {}", false);
            }
        }
        out_embed_dynamic.append("dtjava.embed(\n");
        out_embed_dynamic.append(this.listToString(p_app, poff3)).append(",\n");
        out_embed_dynamic.append(this.listToString(p_platform, poff3)).append(",\n");
        out_embed_dynamic.append(this.listToString(p_callback, poff3)).append("\n");
        out_embed_dynamic.append(poff2).append(");\n");
        String embedFuncName = "javafxEmbed" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params);
        out_embed_onload.append("\n<script>\n");
        out_embed_onload.append(poff).append("function ").append(embedFuncName).append("() {\n");
        out_embed_onload.append(poff2);
        out_embed_onload.append((CharSequence)out_embed_dynamic);
        out_embed_onload.append(poff).append("}\n");
        out_embed_onload.append(poff).append("<!-- Embed FX application into web page once page is loaded -->\n");
        out_embed_onload.append(poff).append("dtjava.addOnloadCallback(").append(embedFuncName).append(");\n");
        out_embed_onload.append("</script>\n");
        if (templateStrings != null) {
            templateStrings.put(TemplatePlaceholders.EMBED_CODE_ONLOAD, out_embed_onload.toString());
            templateStrings.put(TemplatePlaceholders.EMBED_CODE_DYNAMIC, out_embed_dynamic.toString());
        }
        out.println(out_embed_onload.toString());
        out.println("</head><body>");
        out.println("<h2>Test page for <b>" + (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "</b></h2>");
        String string = "return launchApplication('" + jnlpfile_webstart + "');";
        out.println("  <b>Webstart:</b> <a href='" + jnlpfile_webstart + "' onclick=\"" + string + "\">click to launch this app as webstart</a><br><hr><br>");
        out.println("");
        out.println("  <!-- Applet will be inserted here -->");
        out.println("  <div id=" + placeholder + "></div>");
        out.println("</body></html>");
    }

    private void save(File outdir, String fname, byte[] content) throws IOException {
        this.save(new File(outdir, fname), content);
    }

    private void save(File f, byte[] content) throws IOException {
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(content);
        fos.close();
    }

    private static void copyFileToOutDir(InputStream isa, File fout) throws PackagerException {
        File outDir = fout.getParentFile();
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new PackagerException("ERR_CreatingDirFailed", outDir.getPath());
        }
        try (InputStream is = isa;
             FileOutputStream out = new FileOutputStream(fout);){
            int len;
            byte[] buf = new byte[16384];
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (IOException ex) {
            throw new PackagerException(ex, "ERR_FileCopyFailed", outDir.getPath());
        }
    }

    private String getAppletParameters(Map<String, ? super Object> params) {
        StringBuilder result = new StringBuilder();
        boolean addComma = false;
        for (Map.Entry entry : ((Map)ESCAPED_APPLET_PARAMS.fetchFrom(params)).entrySet()) {
            if (addComma) {
                result.append(", ");
            }
            addComma = true;
            result.append("'").append(this.quoteEscape((String)entry.getKey())).append("' : '").append(this.quoteEscape((String)entry.getValue())).append("'");
        }
        for (Map.Entry entry : ((Map)APPLET_PARAMS.fetchFrom(params)).entrySet()) {
            if (addComma) {
                result.append(", ");
            }
            addComma = true;
            result.append("'").append(this.quoteEscape((String)entry.getKey())).append("' : ").append((String)entry.getValue());
        }
        return result.toString();
    }

    String quoteEscape(String s) {
        return s.replaceAll("(['\"\\\\])", "\\\\$1");
    }

    private boolean extractWebFiles(File outDir) throws PackagerException {
        return this.doExtractWebFiles(webFiles, outDir, webfilesDir);
    }

    private boolean doExtractWebFiles(String[] lst, File outDir, String webFilesDir) throws PackagerException {
        File f = new File(outDir, webFilesDir);
        f.mkdirs();
        for (String s : lst) {
            InputStream is = PackagerLib.class.getResourceAsStream(prefixWebFiles + s);
            if (is == null) {
                System.err.println("Internal error. Missing resources [" + prefixWebFiles + s + "]");
                return false;
            }
            JNLPBundler.copyFileToOutDir(is, new File(f, s));
        }
        return true;
    }

    private static enum Mode {
        FX,
        APPLET,
        SwingAPP;

    }
}

